/* -*- Mode:C; Tab-width:4 -*- */
/*                                                                       */
/*                                                                       */
/*                      RESTRICTED RIGHTS LEGEND                         */
/*                                                                       */
/* Use, duplication, or disclosure by the Government is subject to       */
/* restrictions as set forth in subdivision (c)(1)(ii) of the Rights in  */
/* Technical Data and Computer Software clause at 252.227-7013.          */
/*                                                                       */
/*                    TEXAS INSTRUMENTS INCORPORATED.                    */
/*                            P.O. BOX 149149                            */
/*                         AUSTIN, TEXAS 78714-9149                      */
/*                              MS 2151                                  */
/*                                                                       */
/*  Copyright (C) 1986,1987,1988,1989,1990 Texas Instruments Incorporated.*/
/*  All rights reserved.                                                 */
/*   
                                                                    */
#include <time.h>
#include <:bsd:sys:time.h>

long timezone;
int  daylight;

/********************************************************/
/* GETTIMEOFDAY gets the value of time in seconds and   */
/* in microseconds since 00:00:00 GMT, January 1, 1970  */
/* The STRUCTURE timeval pointed to by current_time is  */
/* defined in <sys/time.h>                              */
/********************************************************/
gettimeofday(current_time, time_zone)
struct  timeval  *current_time ;
struct  timezone  *time_zone ;
{
  extern long timezone;
  extern int  daylight;
  int         now;

  GETDATETIME(&now);
  current_time->tv_sec  = now;
  current_time->tv_usec = now * 1000000;
  if (time_zone) {
	time_zone->tz_minuteswest = timezone/60 ;
	time_zone->tz_dsttime = daylight ;
	}
  return(0) ;
}
